/*
	This is a part of the source code for Pro/DESKTOP.
	Copyright (C) 1998-1999 Parametric Technology Corporation.
	All rights reserved.
*/

// Demo spindle and wheel assembly file

#include <stdafx.h>
#include "funcheader.h"
#include "CConvenienceExports.h"


HRESULT DemoSpindleWheelAssembly() 
{
	START_METHOD("SpindleWheelAssembly")
	
	HRESULT status = CONV_SUCCESS;

	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	IWorkplane * activeWorkplane = NULL;
	ISketch * activeSketch = NULL;

	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	AfxMessageBox("Creating Spindle");

	status = GetHelmProDESKTOP();
	CHECK_RETURN_STATUS(status)
	
	CString comp1 = "..\\spindle.des";
	CString comp2 = "..\\wheel.des";

	status = Spindle(comp1, TRUE);

	if (status) {
		AfxMessageBox("DrawSpindle failed");
		return CONV_FAILURE;
	}

	AfxMessageBox(" Creating Wheel ");

	status = Wheel(comp2, TRUE);
	if (status) {
		AfxMessageBox("DrawWheel failed");
		return CONV_FAILURE;
	}

	AfxMessageBox(" Making Assembly ");
	IPartDocument *pdisp = NULL;
	
	status = pdApplication->NewPart(&pdisp);
	if (status || !pdisp) {
		AfxMessageBox("Could not create new part");
		return CONV_FAILURE;
	}

	IDesign *pDesign1 = NULL, *pDesign2 = NULL;
	status = AddComponent(comp1,&pDesign1);
	if (status) {
		AfxMessageBox("AddComponent failed");
		return CONV_FAILURE;
	}

	status = CommitToProDESKTOP("AddComponent");
	CHECK_RETURN_STATUS(status)

	status = AddComponent(comp2,&pDesign1);
	if (status) {
		AfxMessageBox("AddComponent failed");
		return CONV_FAILURE;
	}

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	status = centerAxesPrior();
	if (status) {
		AfxMessageBox("centerAxesPrior failed");
		return CONV_FAILURE;
	}

	status = AlignPlanesPrior();
	if (status) {
		AfxMessageBox("AlignPlanesPrior failed");
		return CONV_FAILURE;
	}

//	double volume=0.0, volumeError=0.0, area=0.0, areaError=0.0;
	/*GetGeometricProperties(density As Double, mass As Double, volume As Double, 
	area As Double, cofgPoint As zVector, momentOfInertia As zMatrix, 
	principalMomentsOfInertia As zVector, principalAxes As zMatrix, 
	radiusOfGyration As zVector)
	*/
//	double density = 1.001;

	double mass = 0.0, volume = 0.0, area = 0.0;
	IVector *cofgPoint = NULL, *principalMomentsOfInertia = NULL, *radiusOfGyration = NULL;
	IMatrix *momentOfInertia = NULL, *principalAxes = NULL;

	status = Massproperties(&mass, &volume, &area, cofgPoint,
		momentOfInertia, principalMomentsOfInertia, principalAxes,
		radiusOfGyration);

	if (status) {
		AfxMessageBox("Massproperties failed");
		return CONV_FAILURE;
	}

	CString strmass;
	strmass.Format("\nMass = %f", mass);
	volume = volume * 1000000000;        //("The Volume in mm3 = "  
	CString strvolume;
	strvolume.Format("\nVolume = %f", volume);
	area = area * 1000000;            //("The Area in mm2 = " 
	CString strarea;
	strarea.Format("\nArea = %f", area);
	CString caption = "\n      MASS   PROPERTIES \n\n";
	CString str = caption + strmass + strvolume + strarea;
	AfxMessageBox(str);

	
	status = ReleaseHelmProDESKTOP();
	CHECK_RETURN_STATUS(status)
	
	END_METHOD("SpindleWheelAssembly")

}

HRESULT Spindle(CString filename, BOOL saveFlag) 
{
	START_METHOD("Spindle")

	HRESULT status = CONV_SUCCESS;

	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	IWorkplane * activeWorkplane = NULL;
	ISketch * activeSketch = NULL;
	IGeometric *localGeometric = NULL;
	IPlane *localZPlane = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_VAR_STATUS(pdApplication)

	IPartDocument *pDisp = NULL;
	status = pdApplication->NewPart(&pDisp);
	CHECK_RETURN_STATUS(status)

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *pVector1 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.15, 0.02, 0, &pVector1);
	CHECK_RETURN_STATUS(status)

	IVector *pVector2 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.15, 0.0375, 0, &pVector2);
	CHECK_RETURN_STATUS(status)

	IVector *pVector3 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.07915, 0.0375, 0, &pVector3);
	CHECK_RETURN_STATUS(status)

	IVector *pVector4 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.07915, 0.0625, 0, &pVector4);
	CHECK_RETURN_STATUS(status)

	IVector *pVector5 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.07915, 0.0625, 0, &pVector5);
	CHECK_RETURN_STATUS(status)

	IVector *pVector6 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.07915, 0.0375, 0, &pVector6);
	CHECK_RETURN_STATUS(status)

	IVector *pVector7 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.15, 0.0375, 0, &pVector7);
	CHECK_RETURN_STATUS(status)

	IVector *pVector8 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.15, 0.02, 0, &pVector8);
	CHECK_RETURN_STATUS(status)

	localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pGeom1 = NULL;
	status = localGeometric->GetGeometry (&pGeom1);
	CHECK_RETURN_STATUS(status)

	localZPlane = CAST(IPlane, pGeom1);

	IDirection *pNormal1 = NULL;
	status = localZPlane->GetNormal(&pNormal1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL, *pLine2 = NULL, *pLine3 = NULL, *pLine4 = NULL;
	ILine *pLine5 = NULL, *pLine6 = NULL, *pLine7 = NULL, *pLine8 = NULL;

	IBasicStraight *curve1 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector1,pVector2,&curve1);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve1), &pLine1);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve2 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector2,pVector3,&curve2);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve2), &pLine2);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve3 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector3,pVector4,&curve3);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve3), &pLine3);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve4 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector4,pVector5,&curve4);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve4), &pLine4);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve5 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector5,pVector6,&curve5);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve5), &pLine5);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve6 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector6,pVector7,&curve6);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve6), &pLine6);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve7 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector7,pVector8,&curve7);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve7), &pLine7);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve8 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector8,pVector1,&curve8);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve8), &pLine8);
	CHECK_RETURN_STATUS(status)

	// Get active workplane

	status = activeGraphicDoc->GetActiveWorkplane(&activeWorkplane);
	CHECK_RETURN_STATUS(status)

	ISketch *initialSketch = NULL;
	status = activeGraphicDoc->GetActiveSketch(&initialSketch);
	CHECK_RETURN_STATUS(status)


	// create Axis ....
	IRevolution *pRev=NULL;
	IDesign *pDesign = NULL;

	IVector *pStart = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.1, 0, 0, &pStart);
	CHECK_RETURN_STATUS(status)

	IVector *pEnd = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0, 0, &pEnd);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve9 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pStart,pEnd,&curve9);
	CHECK_RETURN_STATUS(status)

	ILine *pAxis = NULL;
	status = initialSketch->CreateLine(CAST(ICurve, curve9), &pAxis);
	CHECK_RETURN_STATUS(status)

	//Revolution 
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	//Set the axis as construction line
	pAxis->SetConstruction(VARIANT_TRUE);

	status = CAST(IRevolutionClass2, GetCLASS(Revolution))->CreateRevolution2(pDesign, initialSketch, CAST(IGeometric, pAxis), 6.28, 0, 0, TRUE, 0, &pRev);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Revolution");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	if (saveFlag) {
	VARIANT_BOOL retVal;
	status = activeGraphicDoc->Close(filename.AllocSysString(), TRUE, &retVal);
	CHECK_RETURN_STATUS(status)
	}

	END_METHOD("Spindle")
}

HRESULT Wheel(CString filename, BOOL saveFlag) 
{
	START_METHOD("Wheel")

	HRESULT status = CONV_SUCCESS;

	IApplication *pdApplication = NULL;
	IGraphicDocument *activeGraphicDoc = NULL;
	IPartDocument * activePart = NULL;
	IWorkplane * activeWorkplane = NULL;
	ISketch * activeSketch = NULL;
	IPlane *localZPlane = NULL;
	IGeometric *localGeometric = NULL;
	
	// Get the application
	status = GetProDESKTOPApplication(&pdApplication);
	CHECK_RETURN_STATUS(status)

	IPartDocument *pDisp = NULL;
	status = pdApplication->NewPart(&pDisp);
	CHECK_RETURN_STATUS(status)

	status = GetActivePartWorkplaneSketch(&activePart, &activeGraphicDoc, &activeWorkplane, &activeSketch);
	CHECK_RETURN_STATUS(status)

	IVector *pVector1 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.07915, 0.0625, 0, &pVector1);
	CHECK_RETURN_STATUS(status)

	IVector *pVector2 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.07915, 0.0815,0, &pVector2);
	CHECK_RETURN_STATUS(status)

	IVector *pVector3 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.0125, 0.105, 0, &pVector3);
	CHECK_RETURN_STATUS(status)

	IVector *pVector4 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.0125, 0.155, 0, &pVector4);
	CHECK_RETURN_STATUS(status)

	IVector *pVector5 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.069, 0.1725, 0, &pVector5);
	CHECK_RETURN_STATUS(status)

	IVector *pVector6 = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.069, 0.1875, 0, &pVector6);
	CHECK_RETURN_STATUS(status)

	IVector *pVector7 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.069, 0.1875, 0, &pVector7);
	CHECK_RETURN_STATUS(status)

	IVector *pVector8 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.069, 0.1725, 0, &pVector8);
	CHECK_RETURN_STATUS(status)

	IVector *pVector9 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.0125, 0.155, 0, &pVector9);
	CHECK_RETURN_STATUS(status)

	IVector *pVector10 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.0125, 0.105, 0, &pVector10);
	CHECK_RETURN_STATUS(status)

	IVector *pVector11 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.07915, 0.0815, 0, &pVector11);
	CHECK_RETURN_STATUS(status)

	IVector *pVector12 = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.07915, 0.0625, 0, &pVector12);
	CHECK_RETURN_STATUS(status)

	/////
	localGeometric = CAST(IGeometric, activeWorkplane);

	IGeometry *pGeom = NULL;
	status = localGeometric->GetGeometry (&pGeom);
	CHECK_RETURN_STATUS(status)

	localZPlane = CAST(IPlane, pGeom);
	IDirection *pNormal1 = NULL;
	status = localZPlane->GetNormal(&pNormal1);
	CHECK_RETURN_STATUS(status)

	ILine *pLine1 = NULL, *pLine2 = NULL, *pLine3 = NULL, *pLine4 = NULL, *pLine5 = NULL, *pLine6 = NULL, *pLine7 = NULL, *pLine8 = NULL, *pLine9 = NULL, *pLine10 = NULL, *pLine11 = NULL, *pLine12 = NULL;
	IBasicStraight *curve1 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector1,pVector2,&curve1);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve1), &pLine1);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve2 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector2,pVector3,&curve2);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve2), &pLine2);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve3 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector3,pVector4,&curve3);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve3), &pLine3);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve4 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector4,pVector5,&curve4);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve4), &pLine4);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve5 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector5,pVector6,&curve5);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve5), &pLine5);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve6 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector6,pVector7,&curve6);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve6), &pLine6);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve7 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector7,pVector8,&curve7);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve7), &pLine7);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve8 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector8,pVector9,&curve8);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve8), &pLine8);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve9 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector9,pVector10,&curve9);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve9), &pLine9);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve10 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector10,pVector11,&curve10);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve10), &pLine10);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve11 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector11,pVector12,&curve11);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve11), &pLine11);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve12 = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pVector12,pVector1,&curve12);
	CHECK_RETURN_STATUS(status)

	status = activeSketch->CreateLine(CAST(ICurve, curve12), &pLine12);
	CHECK_RETURN_STATUS(status)

	// get active workplane
	status = activeGraphicDoc->GetActiveWorkplane(&activeWorkplane);
	CHECK_RETURN_STATUS(status)

	ISketch *initialSketch = NULL;
	status = activeGraphicDoc->GetActiveSketch(&initialSketch);
	CHECK_RETURN_STATUS(status)


	// create Axis ....
	IRevolution *pRev=NULL;
	IDesign *pDesign = NULL;

	IVector *pStart = NULL;
	status = (GetCLASS(Vector))->CreateVector(-0.1, 0, 0, &pStart);
	CHECK_RETURN_STATUS(status)

	IVector *pEnd = NULL;
	status = (GetCLASS(Vector))->CreateVector(0.1, 0, 0, &pEnd);
	CHECK_RETURN_STATUS(status)

	IBasicStraight *curve13 = NULL;
	ILine *pAxis = NULL;
	status = (GetCLASS(BasicStraight))->CreateBasicStraightTwoPoints(pStart,pEnd,&curve13);
	CHECK_RETURN_STATUS(status)

	status = initialSketch->CreateLine(CAST(ICurve, curve13), &pAxis);
	CHECK_RETURN_STATUS(status)

	// set the axis as construction line
	pAxis->SetConstruction(VARIANT_TRUE);

	// revolution ....
	status = activePart->GetDesign(&pDesign);
	CHECK_RETURN_STATUS(status)

	status = CAST(IRevolutionClass2, GetCLASS(Revolution))->CreateRevolution2(pDesign, initialSketch, CAST(IGeometric, pAxis), 6.28, 0, 0, TRUE, 0, &pRev);
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("Revolution");
	CHECK_RETURN_STATUS(status)

	status = activePart->UpdateDesign();
	CHECK_RETURN_STATUS(status)

	status = CommitToProDESKTOP("UpdateDesign");
	CHECK_RETURN_STATUS(status)

	if (saveFlag) {
	VARIANT_BOOL retVal;
	status = activeGraphicDoc->Close(filename.AllocSysString(), TRUE, &retVal);
	CHECK_RETURN_STATUS(status)
	}

	END_METHOD("Wheel")
}
